/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding.value;

import com.jgoodies.binding.value.BindingConverter;
import com.jgoodies.binding.value.ConverterValueModel;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.common.base.Preconditions;
import java.text.Format;
import java.text.ParseException;

public final class ConverterFactory {
    private ConverterFactory() {
    }

    public static ValueModel createBooleanNegator(ValueModel booleanSource) {
        return new ConverterValueModel(booleanSource, new BooleanNegator());
    }

    public static ValueModel createBooleanToStringConverter(ValueModel booleanSubject, String trueText, String falseText) {
        return ConverterFactory.createBooleanToStringConverter(booleanSubject, trueText, falseText, "");
    }

    public static ValueModel createBooleanToStringConverter(ValueModel booleanSource, String trueText, String falseText, String nullText) {
        return new ConverterValueModel(booleanSource, new BooleanToStringConverter(trueText, falseText, nullText));
    }

    public static ValueModel createDoubleConverter(ValueModel doubleSource, double multiplier) {
        return new ConverterValueModel(doubleSource, new DoubleConverter(multiplier));
    }

    public static ValueModel createDoubleToIntegerConverter(ValueModel doubleSource) {
        return ConverterFactory.createDoubleToIntegerConverter(doubleSource, 1);
    }

    public static ValueModel createDoubleToIntegerConverter(ValueModel doubleSource, int multiplier) {
        return new ConverterValueModel(doubleSource, new DoubleToIntegerConverter(multiplier));
    }

    public static ValueModel createFloatConverter(ValueModel floatSource, float multiplier) {
        return new ConverterValueModel(floatSource, new FloatConverter(multiplier));
    }

    public static ValueModel createFloatToIntegerConverter(ValueModel floatSource) {
        return ConverterFactory.createFloatToIntegerConverter(floatSource, 1);
    }

    public static ValueModel createFloatToIntegerConverter(ValueModel floatSource, int multiplier) {
        return new ConverterValueModel(floatSource, new FloatToIntegerConverter(multiplier));
    }

    public static ValueModel createIntegerConverter(ValueModel integerSource, double multiplier) {
        return new ConverterValueModel(integerSource, new IntegerConverter(multiplier));
    }

    public static ValueModel createLongConverter(ValueModel longSource, double multiplier) {
        return new ConverterValueModel(longSource, new LongConverter(multiplier));
    }

    public static ValueModel createLongToIntegerConverter(ValueModel longSubject) {
        return ConverterFactory.createLongToIntegerConverter(longSubject, 1);
    }

    public static ValueModel createLongToIntegerConverter(ValueModel longSource, int multiplier) {
        return new ConverterValueModel(longSource, new LongToIntegerConverter(multiplier));
    }

    public static ValueModel createStringConverter(ValueModel source, Format format) {
        return new ConverterValueModel(source, new StringConverter(format));
    }

    public static final class StringConverter
    implements BindingConverter {
        private final Format format;

        StringConverter(Format format) {
            this.format = Preconditions.checkNotNull(format, "The format must not be null.");
        }

        @Override
        public Object targetValue(Object sourceValue) {
            return this.format.format(sourceValue);
        }

        @Override
        public Object sourceValue(Object targetValue) {
            try {
                return this.format.parseObject((String)targetValue);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("Cannot parse the target value " + targetValue, e);
            }
        }
    }

    public static final class LongToIntegerConverter
    implements BindingConverter {
        private final int multiplier;

        LongToIntegerConverter(int multiplier) {
            this.multiplier = multiplier;
        }

        @Override
        public Object targetValue(Object sourceValue) {
            int intValue = ((Long)sourceValue).intValue();
            if (this.multiplier != 1) {
                intValue *= this.multiplier;
            }
            return intValue;
        }

        @Override
        public Object sourceValue(Object targetValue) {
            long longValue = ((Integer)targetValue).longValue();
            if (this.multiplier != 1) {
                longValue /= (long)this.multiplier;
            }
            return longValue;
        }
    }

    public static final class IntegerConverter
    implements BindingConverter {
        private final double multiplier;

        IntegerConverter(double multiplier) {
            this.multiplier = multiplier;
        }

        @Override
        public Object targetValue(Object sourceValue) {
            double doubleValue = ((Integer)sourceValue).doubleValue();
            return (int)(doubleValue * this.multiplier);
        }

        @Override
        public Object sourceValue(Object newValue) {
            double doubleValue = ((Integer)newValue).doubleValue();
            return (int)(doubleValue / this.multiplier);
        }
    }

    public static final class LongConverter
    implements BindingConverter {
        private final double multiplier;

        LongConverter(double multiplier) {
            this.multiplier = multiplier;
        }

        @Override
        public Object targetValue(Object sourceValue) {
            double doubleValue = ((Long)sourceValue).doubleValue();
            return (long)(doubleValue * this.multiplier);
        }

        @Override
        public Object sourceValue(Object targetValue) {
            double doubleValue = ((Long)targetValue).doubleValue();
            return (long)(doubleValue / this.multiplier);
        }
    }

    public static final class FloatToIntegerConverter
    implements BindingConverter {
        private final int multiplier;

        FloatToIntegerConverter(int multiplier) {
            this.multiplier = multiplier;
        }

        @Override
        public Object targetValue(Object sourceValue) {
            float floatValue = ((Float)sourceValue).floatValue();
            if (this.multiplier != 1) {
                floatValue *= (float)this.multiplier;
            }
            return Math.round(floatValue);
        }

        @Override
        public Object sourceValue(Object sourceValue) {
            float floatValue = ((Integer)sourceValue).floatValue();
            if (this.multiplier != 1) {
                floatValue /= (float)this.multiplier;
            }
            return Float.valueOf(floatValue);
        }
    }

    public static final class FloatConverter
    implements BindingConverter {
        private final float multiplier;

        FloatConverter(float multiplier) {
            this.multiplier = multiplier;
        }

        @Override
        public Object targetValue(Object sourceValue) {
            float floatValue = ((Float)sourceValue).floatValue();
            return Float.valueOf(floatValue * this.multiplier);
        }

        @Override
        public Object sourceValue(Object targetValue) {
            float floatValue = ((Float)targetValue).floatValue();
            return Float.valueOf(floatValue / this.multiplier);
        }
    }

    public static final class DoubleToIntegerConverter
    implements BindingConverter {
        private final int multiplier;

        DoubleToIntegerConverter(int multiplier) {
            this.multiplier = multiplier;
        }

        @Override
        public Object targetValue(Object sourceValue) {
            double doubleValue = (Double)sourceValue;
            if (this.multiplier != 1) {
                doubleValue *= (double)this.multiplier;
            }
            return (int)Math.round(doubleValue);
        }

        @Override
        public Object sourceValue(Object targetValue) {
            double doubleValue = ((Integer)targetValue).doubleValue();
            if (this.multiplier != 1) {
                doubleValue /= (double)this.multiplier;
            }
            return doubleValue;
        }
    }

    public static final class DoubleConverter
    implements BindingConverter {
        private final double multiplier;

        DoubleConverter(double multiplier) {
            this.multiplier = multiplier;
        }

        @Override
        public Object targetValue(Object sourceValue) {
            double doubleValue = (Double)sourceValue;
            return doubleValue * this.multiplier;
        }

        @Override
        public Object sourceValue(Object targetValue) {
            double doubleValue = (Double)targetValue;
            return doubleValue / this.multiplier;
        }
    }

    public static final class BooleanToStringConverter
    implements BindingConverter {
        private final String trueText;
        private final String falseText;
        private final String nullText;

        BooleanToStringConverter(String trueText, String falseText, String nullText) {
            this.trueText = Preconditions.checkNotNull(trueText, "The trueText must not be null.");
            this.falseText = Preconditions.checkNotNull(falseText, "The falseText must not be null.");
            this.nullText = Preconditions.checkNotNull(nullText, "The nullText must not be null.");
            Preconditions.checkArgument(!trueText.equals(falseText), "The trueText and falseText must be different.");
        }

        @Override
        public Object targetValue(Object sourceValue) {
            if (Boolean.TRUE.equals(sourceValue)) {
                return this.trueText;
            }
            if (Boolean.FALSE.equals(sourceValue)) {
                return this.falseText;
            }
            if (sourceValue == null) {
                return this.nullText;
            }
            throw new ClassCastException("The subject value must be of type Boolean.");
        }

        @Override
        public Object sourceValue(Object targetValue) {
            if (!(targetValue instanceof String)) {
                throw new ClassCastException("The new value must be a string.");
            }
            String newString = (String)targetValue;
            if (this.trueText.equalsIgnoreCase(newString)) {
                return Boolean.TRUE;
            }
            if (this.falseText.equalsIgnoreCase(newString)) {
                return Boolean.FALSE;
            }
            if (this.nullText.equalsIgnoreCase(newString)) {
                return null;
            }
            throw new IllegalArgumentException("The new value must be one of: " + this.trueText + '/' + this.falseText + '/' + this.nullText);
        }
    }

    public static final class BooleanNegator
    implements BindingConverter {
        @Override
        public Object targetValue(Object sourceValue) {
            return BooleanNegator.negate(sourceValue);
        }

        @Override
        public Object sourceValue(Object targetValue) {
            return BooleanNegator.negate(targetValue);
        }

        private static Boolean negate(Object value) {
            if (value == null) {
                return null;
            }
            if (Boolean.TRUE.equals(value)) {
                return Boolean.FALSE;
            }
            if (Boolean.FALSE.equals(value)) {
                return Boolean.TRUE;
            }
            throw new ClassCastException("The value must be a Boolean.");
        }
    }
}

