/*
 * Decompiled with CFR 0.152.
 */
package com.pannous.desktopctrl.client;

import com.pannous.desktopctrl.client.Helper;
import com.pannous.desktopctrl.client.VoiceCommand;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Handler {
    private String defaultLang;

    public Handler(String defaultLang) {
        this.defaultLang = defaultLang;
    }

    public static boolean containsAllPlusified(String input, String s) {
        if (input.contains(" " + s.replaceAll("\\+", "") + " ")) {
            return true;
        }
        for (String x : s.split("\\+")) {
            if (input.contains(" " + x + " ")) continue;
            return false;
        }
        return true;
    }

    public List<String> getMatchingCommands(String input, Collection<VoiceCommand> commands) {
        String lowerInput = " " + input.toLowerCase() + " ";
        ArrayList<String> matchingCommands = new ArrayList<String>();
        ArrayList<ParseCommandEntry> helperCommands = new ArrayList<ParseCommandEntry>();
        String[] cmdStrs = lowerInput.split(" and ");
        int counter = 0;
        block0: for (String inputCmd : cmdStrs) {
            if ((inputCmd = inputCmd.trim()).isEmpty()) {
                ++counter;
                continue;
            }
            for (VoiceCommand vc : commands) {
                for (String pattern : vc.getKeywords()) {
                    pattern = "^" + pattern.replaceAll("\\%s", "(.*)") + "$";
                    Matcher m = Pattern.compile(pattern).matcher(inputCmd);
                    if (!m.find()) continue;
                    ParseCommandEntry pce = new ParseCommandEntry(inputCmd, vc);
                    helperCommands.add(pce);
                    ++counter;
                    if (m.groupCount() <= 0) continue block0;
                    pce.setParam(m.group(1));
                    continue block0;
                }
            }
        }
        if (counter != cmdStrs.length || helperCommands.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        for (ParseCommandEntry e : helperCommands) {
            counter = 0;
            for (String cmd : e.vc.getCommands()) {
                if (cmd.contains("%s") && counter == 0) {
                    cmd = cmd.replaceAll("\\%s", e.param1);
                    ++counter;
                }
                matchingCommands.add(cmd);
            }
        }
        return matchingCommands;
    }

    public boolean matchWords(String input, Set<String> keywords) {
        String matching = Handler.extractKeyword(input, this.defaultLang, keywords);
        return !Helper.empty(matching);
    }

    public static String extractKeyword(String input, String lang, Set<String> keywords) {
        input = " " + input + " ";
        StringBuilder good = new StringBuilder();
        for (String s : keywords) {
            s = s.replaceAll("\\%s", " ").trim();
            if (input.contains(" " + s + " ")) {
                good.append(' ').append(s);
            }
            if (s.contains("+") && !s.equals("+")) {
                boolean goody = Handler.containsAllPlusified(input, s);
                if (!goody) continue;
                good.append(' ').append(s);
                continue;
            }
            if ("en".equals(lang)) {
                good.append(Handler.collectEnglish(input, s));
                continue;
            }
            if ("de".equals(lang)) {
                good.append(Handler.collectGerman(input, s));
                continue;
            }
            if (!"fr".equals(lang)) continue;
            good.append(Handler.collectFrench(input, s));
        }
        return good.toString().trim();
    }

    private static String collectEnglish(String input, String s) {
        String good = "";
        if (s.equals("i") || s.equals("re")) {
            return good;
        }
        if (input.contains(" " + s + "s ")) {
            good = good + " " + s;
        }
        if (s.endsWith("y")) {
            if (input.replace("ies", "y").contains(" " + s + " ")) {
                good = good + " " + s;
            }
            if (input.replace("ied", "y").contains(" " + s + " ")) {
                good = good + " " + s;
            }
        }
        if (input.contains(" " + s + "d ")) {
            good = good + " " + s;
        }
        if (input.contains(" " + s + "ed ")) {
            good = good + " " + s;
        }
        return good;
    }

    private static String collectFrench(String input, String s) {
        String good = "";
        if (input.contains(" " + s + "s")) {
            good = good + " " + s;
        }
        if (input.contains(" " + s + "t")) {
            good = good + " " + s;
        }
        if (input.contains(" " + s + "et")) {
            good = good + " " + s;
        }
        if (input.contains(" " + s + "re")) {
            good = good + " " + s;
        }
        if (input.contains(" " + s + "er")) {
            good = good + " " + s;
        }
        if (input.contains(" " + s + "es")) {
            good = good + " " + s;
        }
        if (input.contains(" " + s + "ez")) {
            good = good + " " + s;
        }
        if (input.contains(" " + s + "ons")) {
            good = good + " " + s;
        }
        if (input.contains(" " + s + "ent")) {
            good = good + " " + s;
        }
        if (input.contains(" " + s + "\u00e9")) {
            good = good + " " + s;
        }
        if (input.contains(" " + s + "\u00e9e")) {
            good = good + " " + s;
        }
        if (input.contains(" " + s + "ait")) {
            good = good + " " + s;
        }
        if (input.contains(" " + s + "est")) {
            good = good + " " + s;
        }
        return good;
    }

    private static String collectGerman(String input, String s) {
        String good = "";
        if (input.contains(" " + s + "te ")) {
            good = good + " " + s;
        }
        if (input.contains(" " + s + "t ")) {
            good = good + " " + s;
        }
        if (input.contains(" " + s + "n ")) {
            good = good + " " + s;
        }
        if (input.contains(" " + s + "e ")) {
            good = good + " " + s;
        }
        if (input.contains(" " + s + "en ")) {
            good = good + " " + s;
        }
        if (input.contains(" " + s + "es ")) {
            good = good + " " + s;
        }
        if (input.contains(" " + s + "er ")) {
            good = good + " " + s;
        }
        if (input.contains(" " + s + "est ")) {
            good = good + " " + s;
        }
        if (input.contains(" " + s + "et ")) {
            good = good + " " + s;
        }
        if (input.contains(" " + s + "te ")) {
            good = good + " " + s;
        }
        if (input.contains(" " + s + "ten ")) {
            good = good + " " + s;
        }
        if (input.contains(" " + s + "st ")) {
            good = good + " " + s;
        }
        if (input.contains(" " + s + "est ")) {
            good = good + " " + s;
        }
        if (input.contains(" " + s + "test ")) {
            good = good + " " + s;
        }
        if (input.contains(" " + s + "s ")) {
            good = good + " " + s;
        }
        return good;
    }

    private static class ParseCommandEntry {
        VoiceCommand vc;
        String stringCommand;
        String param1 = "";

        public ParseCommandEntry(String stringCommand, VoiceCommand vc) {
            this.vc = vc;
            this.stringCommand = stringCommand;
        }

        public void setParam(String param) {
            this.param1 = param;
        }

        public String toString() {
            return this.stringCommand + ", " + this.param1 + ", " + this.vc.getId();
        }
    }
}

