/*
 * Decompiled with CFR 0.152.
 */
package com.pannous.desktopctrl.client;

import com.pannous.desktopctrl.client.Command;
import com.pannous.desktopctrl.client.Helper;
import java.awt.Desktop;
import java.net.URI;

public class JavaCommand
implements Command {
    private static final String SEARCH = "http://keyboardr.com/nightly/";
    private String action;

    public JavaCommand(String cmd) {
        this.action = cmd;
    }

    @Override
    public boolean doAction() {
        String url;
        if (!Desktop.isDesktopSupported()) {
            return false;
        }
        Desktop desktop = Desktop.getDesktop();
        if (!desktop.isSupported(Desktop.Action.BROWSE)) {
            return false;
        }
        if (this.action.startsWith("open_browser")) {
            url = Helper.getParam(this.action, "open_browser", SEARCH);
        } else if (this.action.startsWith("search_internet")) {
            String search = Helper.getParam(this.action, "search_internet", "news");
            url = "http://keyboardr.com/nightly/#search/" + Helper.encodeUrl(search).replaceAll("\\+", "%20");
        } else {
            return false;
        }
        if (!Helper.empty(url)) {
            try {
                desktop.browse(new URI(url));
                return true;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return false;
    }
}

