/*
 * Decompiled with CFR 0.152.
 */
package com.pannous.desktopctrl.client;

import com.pannous.desktopctrl.client.Command;
import java.awt.Robot;

public class KeyCommand
implements Command {
    private String stroke;
    private int keycode;
    private boolean press;
    private boolean release;
    private final Robot robot;

    public KeyCommand(Robot r, String stroke, int keycode, boolean press, boolean release) {
        this.robot = r;
        this.stroke = stroke.trim();
        if (keycode == 0) {
            throw new IllegalArgumentException("invalid keycode " + keycode + " for " + stroke);
        }
        this.keycode = keycode;
        this.press = press;
        this.release = release;
        if (!press && !release) {
            throw new IllegalStateException("One or both must be set to true: press, release");
        }
    }

    public boolean isPress() {
        return this.press;
    }

    public boolean isRelease() {
        return this.release;
    }

    public int getKeycode() {
        return this.keycode;
    }

    public String getStroke() {
        return this.stroke;
    }

    @Override
    public boolean doAction() {
        try {
            if (this.press) {
                this.robot.keyPress(this.keycode);
            }
            if (this.release) {
                this.robot.keyRelease(this.keycode);
            }
            return true;
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public String toDetailsString() {
        return this.toString() + " (" + this.keycode + ")";
    }

    public String toString() {
        if (this.press && this.release) {
            return "type " + this.stroke;
        }
        if (this.press) {
            return "press " + this.stroke;
        }
        if (this.release) {
            return "release " + this.stroke;
        }
        throw new AssertionError((Object)this.stroke);
    }
}

