/*
 * Decompiled with CFR 0.152.
 */
package com.pannous.desktopctrl.client;

import com.pannous.desktopctrl.client.TextController;
import java.awt.Robot;
import java.util.logging.Logger;

public class Keyboard
implements TextController {
    private final String os;
    private Logger logger = Logger.getLogger("Keyboard");
    private Robot robot;

    public Keyboard(Robot robot) {
        String tmp = System.getProperty("os.name").toLowerCase();
        this.os = tmp.startsWith("windows") ? "windows" : (tmp.contains("nux") ? "unix" : (tmp.contains("mac") ? "mac" : "unknown"));
        this.robot = robot;
    }

    public boolean isUnix() {
        return this.os.equals("unix");
    }

    public boolean isWindows() {
        return this.os.equals("windows");
    }

    public boolean isMac() {
        return this.os.equals("mac");
    }

    public void type(CharSequence characters) {
        int length = characters.length();
        for (int i = 0; i < length; ++i) {
            char character = characters.charAt(i);
            this.type(character);
        }
    }

    public static int getKeyCode(char character) {
        switch (character) {
            case 'a': {
                return 65;
            }
            case 'b': {
                return 66;
            }
            case 'c': {
                return 67;
            }
            case 'd': {
                return 68;
            }
            case 'e': {
                return 69;
            }
            case 'f': {
                return 70;
            }
            case 'g': {
                return 71;
            }
            case 'h': {
                return 72;
            }
            case 'i': {
                return 73;
            }
            case 'j': {
                return 74;
            }
            case 'k': {
                return 75;
            }
            case 'l': {
                return 76;
            }
            case 'm': {
                return 77;
            }
            case 'n': {
                return 78;
            }
            case 'o': {
                return 79;
            }
            case 'p': {
                return 80;
            }
            case 'q': {
                return 81;
            }
            case 'r': {
                return 82;
            }
            case 's': {
                return 83;
            }
            case 't': {
                return 84;
            }
            case 'u': {
                return 85;
            }
            case 'v': {
                return 86;
            }
            case 'w': {
                return 87;
            }
            case 'x': {
                return 88;
            }
            case 'y': {
                return 89;
            }
            case 'z': {
                return 90;
            }
            case '0': {
                return 48;
            }
            case '1': {
                return 49;
            }
            case '2': {
                return 50;
            }
            case '3': {
                return 51;
            }
            case '4': {
                return 52;
            }
            case '5': {
                return 53;
            }
            case '6': {
                return 54;
            }
            case '7': {
                return 55;
            }
            case '8': {
                return 56;
            }
            case '9': {
                return 57;
            }
            case '-': {
                return 45;
            }
            case '=': {
                return 61;
            }
            case '@': {
                return 512;
            }
            case '#': {
                return 520;
            }
            case '$': {
                return 515;
            }
            case '^': {
                return 514;
            }
            case '&': {
                return 150;
            }
            case '*': {
                return 151;
            }
            case '(': {
                return 519;
            }
            case ')': {
                return 522;
            }
            case '_': {
                return 523;
            }
            case '+': {
                return 521;
            }
            case '\t': {
                return 9;
            }
            case '\n': {
                return 10;
            }
            case '[': {
                return 91;
            }
            case ']': {
                return 93;
            }
            case '\\': {
                return 92;
            }
            case ';': {
                return 59;
            }
            case ':': {
                return 513;
            }
            case '\'': {
                return 222;
            }
            case '\"': {
                return 152;
            }
            case ',': {
                return 44;
            }
            case '<': {
                return 153;
            }
            case '.': {
                return 46;
            }
            case '>': {
                return 160;
            }
            case '/': {
                return 47;
            }
            case ' ': {
                return 32;
            }
        }
        return 0;
    }

    public void type(char character) {
        int keycode = Keyboard.getKeyCode(character);
        if (keycode != 0) {
            this.doType(keycode);
        } else {
            if (!this.isUnix()) {
                if ("windows".equals(this.os)) {
                    this.logger.warning("Cannot type character " + character);
                    return;
                }
                if ("mac".equals(this.os)) {
                    this.logger.warning("Cannot type character " + character);
                    return;
                }
                this.logger.warning("Cannot type character " + character);
                return;
            }
            this.robot.keyPress(17);
            this.robot.keyPress(16);
            this.type('u');
            this.robot.keyRelease(16);
            this.robot.keyRelease(17);
            String s = String.format("%04x", character);
            for (int i = 0; i < s.length(); ++i) {
                this.type(s.charAt(i));
            }
            if (this.isUnix()) {
                this.robot.keyPress(10);
                this.robot.keyRelease(10);
            } else if (this.isWindows()) {
                this.robot.keyRelease(18);
            } else if (this.isMac()) {
                // empty if block
            }
        }
    }

    private void doType(int ... keyCodes) {
        this.doType(keyCodes, 0, keyCodes.length);
    }

    private void doType(int[] keyCodes, int offset, int length) {
        if (length == 0) {
            return;
        }
        this.robot.keyPress(keyCodes[offset]);
        this.doType(keyCodes, offset + 1, length - 1);
        this.robot.keyRelease(keyCodes[offset]);
    }

    public void doPaste() {
        this.doType(17, 86);
    }

    public void doCopy() {
        this.doType(17, 67);
    }

    @Override
    public void write(String text) {
        text = text.replaceAll("\u00e4", "ae");
        text = text.replaceAll("\u00f6", "oe");
        text = text.replaceAll("\u00fc", "ue");
        text = text.replaceAll("\u00df", "ss");
        text = text.replaceAll("\u00c4", "Ae");
        text = text.replaceAll("\u00d6", "Oe");
        text = text.replaceAll("\u00dc", "Ue");
        this.type(text);
    }

    public void doAltTab() {
        this.robot.keyPress(18);
        this.robot.keyPress(9);
        this.robot.keyRelease(9);
        this.robot.keyRelease(18);
    }
}

