/*
 * Decompiled with CFR 0.152.
 */
package com.pannous.desktopctrl.client;

import com.pannous.desktopctrl.client.Helper;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class VoiceCommand {
    private String id;
    private String category = "";
    private String description = "";
    private Set<String> keywords;
    private List<String> commands;

    public VoiceCommand(String id) {
        this.id = id;
        this.keywords = new LinkedHashSet<String>();
        this.commands = new ArrayList<String>();
    }

    public VoiceCommand addKeyword(String kw) {
        if (kw.trim().isEmpty()) {
            throw new IllegalStateException("keyword cannot be empty");
        }
        this.keywords.add(kw.trim().toLowerCase());
        return this;
    }

    public VoiceCommand addCommand(String kw) {
        this.commands.add(kw);
        return this;
    }

    public List<String> getCommands() {
        return this.commands;
    }

    public Set<String> getKeywords() {
        return this.keywords;
    }

    public String getId() {
        return this.id;
    }

    public VoiceCommand setDescription(String description) {
        this.description = description;
        if (Helper.empty(description)) {
            throw new IllegalStateException("description cannot be empty");
        }
        return this;
    }

    public VoiceCommand setCategory(String category) {
        if (Helper.empty(category)) {
            throw new IllegalStateException("category cannot be empty");
        }
        this.category = category;
        return this;
    }

    public String getCategory() {
        return this.category;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return this.id + " " + this.getKeywords();
    }
}

